$(function () {

	

	Application.init ();

	

});







var Application = function () {

	

	var validationRules = getValidationRules ();

	

	return { init: init, validationRules: validationRules };

	

	function init () {

		

		enableBackToTop ();

		enableLightbox ();

		enableCirque ();

		enableEnhancedAccordion ();



	}



	function enableCirque () {

		if ($.fn.lightbox) {

			$('.ui-lightbox').lightbox ();

		}

	}



	function enableLightbox () {

		if ($.fn.cirque) {

			$('.ui-cirque').cirque ({  });

		}

	}



	function enableBackToTop () {

		var backToTop = $('<a>', { id: 'back-to-top', href: '#top' });

		var icon = $('<i>', { class: 'icon-chevron-up' });



		backToTop.appendTo ('body');

		icon.appendTo (backToTop);

		

	    backToTop.hide();



	    $(window).scroll(function () {

	        if ($(this).scrollTop() > 150) {

	            backToTop.fadeIn ();

	        } else {

	            backToTop.fadeOut ();

	        }

	    });



	    backToTop.click (function (e) {

	    	e.preventDefault ();



	        $('body, html').animate({

	            scrollTop: 0

	        }, 600);

	    });

	}

	

	function enableEnhancedAccordion () {

		$('.accordion').on('show', function (e) {

	         $(e.target).prev('.accordion-heading').parent ().addClass('open');

	    });

	

	    $('.accordion').on('hide', function (e) {

	        $(this).find('.accordion-toggle').not($(e.target)).parents ('.accordion-group').removeClass('open');

	    });

	    

	    $('.accordion').each (function () {	    	

	    	$(this).find ('.accordion-body.in').parent ().addClass ('open');

	    });

	}

	

	function getValidationRules () {

		var custom = {

	    	focusCleanup: false,

			

			wrapper: 'div',

			errorElement: 'span',

			

			highlight: function(element) {

				$(element).parents ('.control-group').removeClass ('success').addClass('error');

			},

			success: function(element) {

				$(element).parents ('.control-group').removeClass ('error').addClass('success');

				$(element).parents ('.controls:not(:has(.clean))').find ('div:last').before ('<div class="clean"></div>');

			},

			errorPlacement: function(error, element) {

				error.appendTo(element.parents ('.controls'));

			}

	    	

	    };

	    

	    return custom;

	}

	

}();