<?php

class Payment_controller extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->library("Instamojo");
    }

    function index() {
        $api = new Instamojo(API_KEY, AUTH_TOKEN, 'https://www.instamojo.com/api/1.1/');  //--> Testing api link
        //$api = new Instamojo(API_KEY, AUTH_TOKEN);  //--> Live api link
        $transaction_id = $this->input->get_post("transaction_id");
        $instamojo_redirect_url = base_url() . 'payment_controller/success?txn_id=' . $transaction_id;

        $data = $this->db->get_where("payments_ledger", ["request_id" => $transaction_id])->row();
        $user = $this->user_model->get_user_details($data->user_id);
        try {
            $response = $api->paymentRequestCreate(array(
                "purpose" => "Wallet update " . $this->data["site_property"]->site_title,
                "amount" => $data->amount,
                "buyer_name" => $user->name,
                "send_email" => true,
                "email" => isset($user->username) ? $user->username : "info@v2youserve.com",
                "redirect_url" => $instamojo_redirect_url
            ));
            //redirect($response['longurl']);
            //print_r($response);
            redirect($response['longurl']);
        } catch (Exception $e) {
            print('Error: ' . $e->getMessage());
        }
        die;
    }

    function success() {


        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://www.instamojo.com/api/1.1/payments/' . $this->input->get_post('payment_id') . '/');
        curl_setopt($ch, CURLOPT_HEADER, FALSE);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, TRUE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array("X-Api-Key:" . API_KEY,
            "X-Auth-Token:" . AUTH_TOKEN));

        $response = curl_exec($ch);
        curl_close($ch);

        //echo $response;

        $payment_response = json_decode($response);


        if ($payment_response->payment->status == "Failed") {
            $this->db->where("request_id", $this->input->get_post('txn_id'));
            $this->db->set("transaction_ref_id", $this->input->get_post('payment_id'));
            $this->db->set("request_status", "Cancelled");
            $this->db->set("by_ref", "Wallet update request was cancelled due to low balance or invalid account details");
            $this->db->set("updated_at", time());
            if ($this->db->update("payments_ledger")) {
                $data = $this->db->get_where("payments_ledger", ["request_id" => $this->input->get_post('txn_id')])->row();
                if ($data->source == "App") {
                    redirect("payment_controller/mobile_app_failure");
                } else {
                    echo "<script>alert('Payment Failure');location.href='" . base_url() . "customer/transactions'</script>";
                }
            }
        } else {
            $this->db->where("request_id", $this->input->get_post('txn_id'));
            $this->db->set("transaction_ref_id", $this->input->get_post('payment_id'));
            $this->db->set("request_status", "Completed");
            $this->db->set("by_ref", "Added money to wallet by payment gateway");
            $this->db->set("updated_at", time());
            if ($this->db->update("payments_ledger")) {
                $data = $this->db->get_where("payments_ledger", ["request_id" => $this->input->get_post('txn_id')])->row();
                if ($data->source == "App") {
                    redirect("payment_controller/mobile_app_success");
                } else {
                    echo "<script>alert('Payment Successful, Your wallet amount has been updated');location.href='" . base_url() . "customer/transactions'</script>";
                }
            }
        }
    }

    function mobile_app_success() {
        
    }

    function mobile_app_failure() {
        
    }

    function failure() {
        $this->db->where("request_id", $this->input->get_post('txn_id'));
        $this->db->set("transaction_ref_id", $this->input->get_post('payment_id'));
        $this->db->set("request_status", "Cancelled");
        $this->db->set("updated_at", time());
        if ($this->db->update("payments_ledger")) {
            $data = $this->db->get_where("payments_ledger", ["request_id" => $this->input->get_post('txn_id')])->row();
            if ($data->source == "App") {
                echo "failure";
            } else {
                echo "<script>alert('Payment Failure');location.href='" . base_url() . "customer/transactions'</script>";
            }
        }
    }

}
