<?php

class Add_plots extends CI_Controller {

    private $data;

    function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        $this->data["ventures"] = $this->admin_model->get_active_ventures();
        $this->admin_view("add_plots");
    }

    function add() {
		
		if(!empty($_POST)){
			
			$start = $this->input->get_post('start_number');
			$to = $this->input->get_post('to_number');
			$venture_id = $this->input->get_post('venture_id');
			if($start < $to){
				
				
				for($i=$start; $i<$to; $i++){
					
					$plot_number = $i;
					
					$this->db->where("plot_number", $plot_number);
					$this->db->where("venture_id", $venture_id);
					
					if($this->db->get("plots")->num_rows()==0){
						$this->db->set("venture_id", $venture_id);
						$this->db->set("plot_number", $plot_number);
						$this->db->set("availability_status", "Available");
						$this->db->set("created_at", time());
						$this->db->insert("plots");
					}
				}
			}else if($to<=$start){
				for($i=$to; $i<=$start; $i++){
					
					$plot_number = $i;
					
					$this->db->where("plot_number", $plot_number);
					$this->db->where("venture_id", $venture_id);
					
					if($this->db->get("plots")->num_rows()==0){
						$this->db->set("venture_id", $venture_id);
						$this->db->set("plot_number", $plot_number);
						$this->db->set("availability_status", "Available");
						$this->db->set("created_at", time());
						$this->db->insert("plots");
					}
				}
			}
			
			redirect("admin/view_plots?status=success");
			
		}
	
        $this->admin_view("add_view");
    }

    function edit($item_primary_key) {
        if ($this->data["action_buttons"]['edit_action'] == false) {
            die("Access Deined for edit operation");
        }
        $this->data['edit_item_row'] = $this->curd_model->get_row_from_pk($this->data['primary_table_name'], $item_primary_key);
        $this->admin_view("edit_view");
    }

    function delete($item_primary_key) {
        if ($this->data["action_buttons"]['delete_action'] == true) {
            $this->db->where("id", $item_primary_key);
            $this->db->delete($this->data['primary_table_name']);
            redirect($this->data['current_page_link'] . "?msg=delete");
        } else {
            redirect($this->data['current_page_link']);
        }
    }

    function toggle_status($item_primary_key) {
        $current_status = $this->curd_model->get_status($this->data['primary_table_name'], $item_primary_key);
        if ($current_status != FALSE) {
            $this->curd_model->toggle_status($this->data['primary_table_name'], $item_primary_key, $current_status);
        }
        redirect($this->data['current_page_link'] . "?msg=update");
    }

}
