<?php

class Completed_bank_payments extends CI_Controller {

    private $data;

    function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }

        $this->data['add_subject'] = "Bank Payments";
        $this->data['subject'] = plural($this->data['add_subject']);
        $this->data['primary_table_name'] = "to_bank_transactions";
        $this->data['current_page_link'] = base_url() . "admin/" . strtolower(__CLASS__);

        $this->data['primary_uri_segment_name'] = $this->data['primary_table_name'];

        $this->data['column_name_display_as'] = array('time' => 'Date and Time');
        $this->data['hide_columns_in_list_view'] = array("updated_at");

        $this->data['hide_columns_in_edit_view'] = array("updated_at", 'unique_code');
        $this->data['hide_columns_in_add_view'] = array("unique_code", "status");
        $this->data['image_fields'] = array('image');
        $this->data['email_fields'] = array('username', 'email');

        $this->data['action_buttons'] = array(
            "delete_action" => false,
            "edit_action" => false,
            "add_action" => false,
            "view_action" => false
        );

        $this->data['button_size'] = "xs";


        $this->data['unset_all_actions'] = false;

        $this->data['editor_type'] = "standard";
        $this->data['password_fields'] = array("password");
        $this->data['readonly_fields'] = array();

        $this->data['relation_fields'] = array(
            'role_id' => array('table_name' => 'roles', 'display_column_name' => 'name', "condition" => array("")),
            'user_id' => array('table_name' => 'users', 'display_column_name' => 'name,mobile', "condition" => array(""))
        );
        $this->data['multiple_selection_of_options'] = array("role_ids");

        $this->data['column_name_display_as'] = array('role_id' => 'User Role', 'time' => 'Date and Time');

        $this->data['unique_fileds'] = array();

        $this->data['signle_file_browse_fileds'] = array();

        $this->data["image_columns_properties"] = array(
            "image" => array("max_size" => "10000", //in kb format only
                "accepted_file_formats" => array("png", "jpeg", "jpg", "gif"))
        );

        $this->data["exclude_ck_editor_fields"] = array("message");
        $this->data['date_fields'] = array(
            'type_date'
        );

        $this->data['add_action_buttons'] = array();

        $this->data["generate_random_key_fields"] = array();

        if ($this->input->is_ajax_request()) {
            if (isset($_GET['existed_value'])) {
                $keys = array_keys($_POST);
                if ($this->db->get_where($this->data['primary_table_name'], [$keys[0] => $_REQUEST[$keys[0]], $keys[0] . "!=" => $_REQUEST['existed_value']])->num_rows()) {
                    echo "false";
                } else {
                    echo "true";
                }
            } else {
                $keys = array_keys($_POST);
                if ($this->db->get_where($this->data['primary_table_name'], [$keys[0] => $_REQUEST[$keys[0]]])->num_rows()) {
                    echo "false";
                } else {
                    echo "true";
                }
            }
            exit;
        }

        $this->data["fileds_info"] = $this->curd_model->get_fields($this->data['primary_table_name']);


        if (!empty($_POST)) {


            if (isset($_POST['submit'])) {

                foreach ($this->data['date_fields'] as $key_item) {
                    if ($this->db->field_exists($key_item, $this->data['primary_table_name'])) {
                        $_POST[$key_item] = get_database_date_format_from_us($_POST[$key_item]);
                    }
                }
                if ($_POST['submit'] == "insert") {
                    unset($_POST['submit']);
                    //print_r($_POST);

                    foreach ($this->data['generate_random_key_fields'] as $key_item) {
                        if ($this->db->field_exists($key_item, $this->data['primary_table_name'])) {
                            $_POST[$key_item] = $this->curd_model->generate_random_string_code($this->data['primary_table_name'], $key_item);
                        }
                    }


                    $keys = array_keys($_POST);

                    $obj = new Requests();
                    $obj->is_password_update_required = FALSE;
                    $obj->tableName = $this->data['primary_table_name'];
                    $obj->fillable = $keys;

                    foreach ($this->data['image_fields'] as $item) {
                        if (isset($_FILES[$item . '__i']['name'])) {
                            if ($_FILES[$item . '__i']['name'] != '') {
                                array_push($obj->fillable, $item . '__i');
                            }
                        }
                    }
                    if ($obj->posted_values_dynamic_save()) {
                        redirect($this->data['current_page_link'] . "?msg=add");
                        //any extra code such as email, sms functionality code
                        //js_redirect($back_button_nav."?msg=add");
                    }
                } else if ($_POST['submit'] == "update") {

                    unset($_POST['submit']);


                    $obj = new Requests();

                    $id = $_POST['id'];
                    if (isset($_POST['password'])) {
                        if ($_POST['password'] != '') {
                            $password = $_POST['password'];
                            unset($_POST['password']);
                            $obj->is_password_update_required = FALSE;
                        }
                    }

                    $keys = array_keys($_POST);


                    $obj->tableName = $this->data['primary_table_name'];
                    $obj->whereCnd = array("id" => $id);
                    $obj->fillable = $keys;
                    foreach ($this->data['image_fields'] as $item) {
                        if (isset($_FILES[$item . '__i']['name'])) {
                            if ($_FILES[$item . '__i']['name'] != '') {
                                array_push($obj->fillable, $item . '__i');
                            }
                        }
                    }
                    if (isset($password)) {
                        $_POST['password'] = $password;
                        array_push($obj->fillable, 'password');
                    }

                    if ($obj->posted_values_dynamic_update()) {

                        $user_id = $this->input->get_post("user_id");
                        $ref_id = $this->generate_transaction_token();
                        if ($this->input->get_post('transaction_status') == "Completed") {
                            $this->db->set("payment_status", "Paid");
                            $this->db->set("payment_gateway_id", $this->input->get_post('bank_transaction_id'));
                            $this->db->set("ref_id", $ref_id);
                            $this->db->set("updated_at", time());
                            if ($this->db->insert("payments")) {
                                $udetails = $this->user_model->get_user_details($user_id);

                                if (!$udetails->subscription_expiry_date) {
                                    $valid_days = $this->site_model->get_site_properties()->valid_for_days;
                                    $new_valid_date = date("Y-m-d", strtotime("+" . $valid_days . " days"));
                                    $indian_format = date("m-d-Y", strtotime("+" . $valid_days . " days"));
                                    $this->db->set("subscription_expiry_date", $new_valid_date);
                                    $this->db->set("subscription_mode", "Subscription");
                                    $this->db->where("id", $user_id);
                                    $this->db->update("users");
                                } else {

                                    $this->db->where("subscription_expiry_date > ", date("Y-m-d"));
                                    $this->db->where("id", $user_id);
                                    $u_info = $this->db->get("users")->row();
                                    if ($u_info) {
                                        //extend subscription

                                        $valid_days = date("Y-m-d", strtotime("+30 days", strtotime($u_info->subscription_expiry_date)));
                                        $indian_format = date("m-d-Y", strtotime("+30 days", strtotime($u_info->subscription_expiry_date)));

                                        $indian_format = date("m-d-Y", strtotime("+" . $valid_days . " days"));
                                        $this->db->set("subscription_expiry_date", $new_valid_date);
                                        $this->db->where("id", $user_id);
                                        $this->db->set("updated_at", time());
                                        $this->db->update("users");
                                    } else {
                                        //give full subscription 
                                        $valid_days = $this->site_model->get_site_properties()->valid_for_days;
                                        $new_valid_date = date("Y-m-d", strtotime("+" . $valid_days . " days"));
                                        $indian_format = date("m-d-Y", strtotime("+" . $valid_days . " days"));
                                        $this->db->set("subscription_expiry_date", $new_valid_date);
                                        $this->db->where("id", $user_id);
                                        $this->db->set("updated_at", time());
                                        $this->db->update("users");
                                    }
                                }

                                $this->db->where("ref_id", $ref_id);
                                $this->db->set("remark", "Renewal request completed, amount received, New subscription expiry date is " . $indian_format);
                                $this->db->update("payments");

                                $message = "Dear " . $udetails->name . ",\nCongratulaions your subscription renewed successfully, and valid upto " . $indian_format;
                                send_message($message, $udetails->mobile);
                            }
                        }

                        //any extra code such as email, sms functionality code
                        redirect($this->data['current_page_link'] . "?msg=update");
                    }
                }
            }
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/curd_files/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        $this->db->where("transaction_status", "Completed");
        $this->data["list_items"] = $this->curd_model->get_all_data_from_table($this->data['primary_table_name']);
        $this->admin_view("list_view");
    }

    function add() {
        if ($this->data["action_buttons"]['add_action'] == false) {
            die("Access Deined for add operation");
        }
        $this->admin_view("add_view");
    }

    function edit($item_primary_key) {
        if ($this->data["action_buttons"]['edit_action'] == false) {
            die("Access Deined for edit operation");
        }
        $this->data['edit_item_row'] = $this->curd_model->get_row_from_pk($this->data['primary_table_name'], $item_primary_key);
        $this->admin_view("edit_view");
    }

    function delete($item_primary_key) {
        if ($this->data["action_buttons"]['delete_action'] == true) {
            $this->db->where("id", $item_primary_key);
            $this->db->delete($this->data['primary_table_name']);
            redirect($this->data['current_page_link'] . "?msg=delete");
        } else {
            redirect($this->data['current_page_link']);
        }
    }

    function toggle_status($item_primary_key) {
        $current_status = $this->curd_model->get_status($this->data['primary_table_name'], $item_primary_key);
        if ($current_status != FALSE) {
            $this->curd_model->toggle_status($this->data['primary_table_name'], $item_primary_key, $current_status);
        }
        redirect($this->data['current_page_link'] . "?msg=update");
    }

    function generate_transaction_token() {
        $ref_id = generateRandomNumber(8);
        if ($this->db->get_where("payments", ["ref_id" => $ref_id])->num_rows() == 0) {
            return $ref_id;
        } else {
            return $this->generate_transaction_token();
        }
    }

}
