<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Payments_ledger extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        redirect('admin/payments_ledger/manage');
    }

    function manage() {
        if ($this->input->get_post('q')) {
            $this->data["user"] = $this->db->get_where("users", ["mobile" => $this->input->get_post('q')])->row();
            $this->db->order_by("id", "desc");
            $this->data["payments_ledger"] = $this->db->get_where("payments_ledger", ["user_id" => $this->data["user"]->id])->result();
        }

        if (!empty($_POST)) {
            if ($this->input->get_post('action_type') == "Credit") {
                $request_id = $this->business_model->generate_payment_cr_ledger_request_id();
                $by_ref = "Amount Credited by admin";
            } else {
                $request_id = $this->business_model->generate_payment_db_ledger_request_id();
                $by_ref = "Amount Debited by admin";
            }
            $this->db->set("request_id", $request_id);
            $this->db->set("action_type", $this->input->get_post('action_type'));
            $this->db->set("amount", $this->input->get_post('amount'));
            $this->db->set("user_id", $this->input->get_post('user_id'));
            $this->db->set("transaction_ref_id", $this->input->get_post('transaction_ref_id'));
            $this->db->set("created_at", time());
            $this->db->set("remark", $this->input->get_post('remark'));
            $this->db->set("by_ref", $by_ref);
            $this->db->set("request_status", "Completed");
            $response = $this->db->insert("payments_ledger");
            if ($response) {
                redirect('admin/payments_ledger/manage?q=' . $this->input->get_post('q') . "&msg=success");
            }
        }

        $this->admin_view("payment_legder_manage");
    }

    function approve() {
        $remark = $this->input->get_post('remark');
        $q = $this->input->get_post('q');
        $this->db->set("remark", $remark);
        $this->db->set("request_status", "Completed");
        $this->db->where("id", $this->input->get_post('id'));
        $response = $this->db->update("payments_ledger");
        if ($response) {
            echo "<script>"
            . "alert('Updated Successfully');location.href='" . base_url() . "admin/payments_ledger/manage?q=" . $q . "'</script>";
        }
    }

}
