<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Reports extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        redirect('admin/reports/manage');
    }

    function manage($state_id = '') {
        if ($this->input->get_post('s') || isset($state_id)) {
			if($this->input->get_post('s')){
				$this->data['state_id'] = $this->input->get_post('s');
			}else{
				$this->data['state_id'] = $state_id;
			}
			$this->db->where('(state_id = "'.$state_id.'" or state_id = "'.$this->input->get_post('s').'")');
			$this->db->where('status',1);
			$this->data['cities'] = $this->db->get("cities")->result();
		}
		if($this->input->get_post('s') && $this->input->get_post('c') && $this->input->get_post('r')){
			$this->db->select('u.*,s.name as state_title,c.name as city_title');
			$this->db->from('users u');
			$this->db->join('states s','s.id=u.state_id');
			$this->db->join('cities c','c.id=u.city_id');
			$this->db->where('u.state_id',$this->input->get_post('s'));
			$this->db->where('u.city_id',$this->input->get_post('c'));
			$this->db->where('u.role_id',$this->input->get_post('r'));
			if($this->input->get_post('fd')){
				$this->db->where('u.created_at >',strtotime($this->input->get_post('fd').' 00:00:00'));
			}
			if($this->input->get_post('td')){
				$this->db->where('u.created_at <',strtotime($this->input->get_post('td').' 23:59:59'));
			}
			$result = $this->db->get()->result();
			foreach($result as $item){
				if($item->role_id == $this->roles_model->get_customer_role_id()){
					$item->wallet_balance = $this->customer_model->get_wallet_balance($item->id);
				}elseif($item->role_id == $this->roles_model->get_vendor_role_id()){
					$pincode_string = explode(',',$item->authorized_pincodes);
					$pincodes = array();
					foreach($pincode_string as $pitem){
						$this->db->where('id',$pitem);
						$pincodes[] = $this->db->get('pincodes')->row()->pincode;
					}
					$item->pincode = implode(', ',$pincodes);
					$item->wallet_balance = $this->vendor_model->get_wallet_balance($item->id);
				}elseif($item->role_id == $this->roles_model->get_franchise_role_id()){
					$pincode_string = explode(',',$item->authorized_pincodes);
					$pincodes = array();
					foreach($pincode_string as $pitem){
						$this->db->where('id',$pitem);
						$pincodes[] = $this->db->get('pincodes')->row()->pincode;
					}
					$item->pincode = implode(', ',$pincodes);
					$item->wallet_balance = $this->franchise_model->get_wallet_balance($item->id);
				}
			}
			$this->data['reports'] = $result;
		}
		$this->db->where('status',1);
		$this->data['states'] = $this->db->get("states")->result();
		$this->db->where('status',1);
		$this->db->where("(id != '1' && id != '2')");
		$this->data['roles'] = $this->db->get("roles")->result();
        $this->admin_view("reports_manage");
    }

    function approve() {
        $remark = $this->input->get_post('remark');
        $q = $this->input->get_post('q');
        $this->db->set("remark", $remark);
        $this->db->set("request_status", "Completed");
        $this->db->where("id", $this->input->get_post('id'));
        $response = $this->db->update("reports");
        if ($response) {
            echo "<script>"
            . "alert('Updated Successfully');location.href='" . base_url() . "admin/reports/manage?q=" . $q . "'</script>";
        }
    }

}
