<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Service_orders extends CI_Controller {

    private $data;

    function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        $total_results = $this->get_service_orders();

        $limit = $this->input->get_post("limit") ? $this->input->get_post("limit") : ORDERS_PER_PAGE;
        $_GET['page'] = $this->input->get_post("page");
        $start = $this->input->get_post("page") > 1 ? ($this->input->get_post("page") - 1) * $limit : 0;


        $pagination = my_pagination("admin/service_orders", $limit, $total_results, false);
        $pagination['pagination'] = str_replace("&amp;", "&", $pagination['pagination']);

        $this->data['items'] = $this->get_service_orders($start, $limit);
        $this->data['pagination'] = $pagination['pagination'];
        $this->data['page_title'] = 'Service Orders';
        $this->admin_view("service_orders_list");
    }

    function service_order_view($id) {
        $this->db->select('srb.*,u.name as customer_name');
        $this->db->from('service_request_bookings srb');
        $this->db->join('users u', 'u.id=srb.user_id');
        $this->db->where('srb.id', $id);
        $this->db->where('srb.status', 1);
        $this->data['item'] = $this->db->get()->row();

        $this->data['item']->customer_pincode = $this->data['item']->customer_pincode . ", " . $this->data['item']->customer_pincode_location_name;


        $this->data['item']->sub_category_name = $this->db->get_where("sub_categories", ["id" => $this->data['item']->sub_category_id])->row()->name;

        $this->db->select('srbl.*,u.name as person_name,r.name as role_name');
        $this->db->from('service_request_bookings_log srbl');
        $this->db->join('users u', 'u.id=srbl.action_by_user_id');
        $this->db->join('roles r', 'r.id=u.role_id');
        $this->db->where('srbl.service_request_bookings_id', $this->data['item']->id);
        $this->data['process_log'] = $this->db->get()->result();
        $this->data['item']->user_details = $this->user_model->get_user_details($this->data['item']->user_id);
        $this->data['page_title'] = 'Service Orders';
        $this->admin_view("service_order_view");
    }

    function get_service_orders($start = null, $limit = null) {
        $this->db->select('srb.*,u.name as customer_name');
        $this->db->from('service_request_bookings srb');
        $this->db->join('users u', 'u.id=srb.user_id');
        if ($this->input->get_post('q')) {
            $query_str = $this->input->get_post('q');
            $this->db->where('(srb.booking_id="' . $query_str . '" OR u.mobile="' . $query_str . '" OR u.pincode="' . $query_str . '" OR u.username="' . $query_str . '")');
        }
        if ($this->input->get_post('s')) {
            $this->db->where('srb.service_status', $this->input->get_post('s'));
        }
        if ($this->input->get_post('fd')) {
            $fd = strtotime($this->input->get_post('fd') . ' 00:00:00');
            $this->db->where('srb.created_at>', $fd);
        }
        if ($this->input->get_post('td')) {
            $td = strtotime($this->input->get_post('td') . ' 23:59:59');
            $this->db->where('srb.created_at<', $td);
        }
        $this->db->where('srb.status', 1);
        $this->db->group_by("srb.id", "desc");
        if ($start == null && $limit == null) {
            return $this->db->count_all_results("service_request_bookings");
        }
        $this->db->order_by("id", "desc");
        $this->db->limit($limit, $start);
        $result = $this->db->get()->result();
        return $result;
    }

}
