<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

class Withdraw_requests extends CI_Controller {

    public function __construct() {
        parent::__construct();
        if ($this->site_model->check_for_user_logged() == false) {
            redirect("admin/login");
        }
    }

    function admin_view($design = null) {
        $this->load->view("admin/includes/header", $this->data);
        $this->load->view("admin/" . $design);
        $this->load->view("admin/includes/footer", $this->data);
    }

    function index() {
        redirect('admin/withdraw_requests/manage');
    }

    function manage() {

        if ($this->input->get_post('q')) {
            $this->data["user"] = $this->db->get_where("users", ["mobile" => $this->input->get_post('q')])->row();
            $this->data["payments_ledger"] = $this->db->get_where("payments_ledger", ["user_id" => $this->data["user"]->id, "action_by" => "Withdraw", "request_status" => "Pending"])->result();
        } else {
            $this->data["payments_ledger"] = $this->db->get_where("payments_ledger", ["action_type" => "Debit", "request_status" => "Pending"])->result();
        }

        foreach ($this->data["payments_ledger"] as $item) {
            $item->bank_details = $this->db->get_where("users", ["id" => $item->user_id])->row();
        }

        if (!empty($_POST)) {
            $request_id = $this->business_model->generate_payment_db_ledger_request_id();
            $this->db->set("transaction_ref_id", $this->input->get_post('transaction_ref_id'));
            $this->db->set("updated_at", time());
            $this->db->set("remark", $this->input->get_post('remark'));
            $this->db->set("request_status", "Completed");
            $this->db->where("id", $this->input->post('id'));
            $response = $this->db->update("payments_ledger");
            if ($response) {
                $this->business_model->customer_wallet_amount_updated($this->input->get_post('id'));
                redirect('admin/withdraw_requests/manage?q=' . $this->input->get_post('q') . "&msg=success");
            }
        }

        $this->admin_view("withdraw_requests");
    }

    function approve() {
        $remark = $this->input->get_post('remark');
        $q = $this->input->get_post('q');
        $this->db->set("remark", $remark);
        $this->db->set("request_status", "Completed");
        $this->db->where("id", $this->input->get_post('id'));
        $response = $this->db->update("payments_ledger");
        if ($response) {
            $this->business_model->customer_wallet_amount_updated($this->input->get_post('id'));
            echo "<script>"
            . "alert('Updated Successfully');location.href='" . base_url() . "admin/withdraw_requests/manage?q=" . $q . "'</script>";
        }
    }

}
