<?php

header('Content-type: application/json');

class Add_subscription_request extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->input->get_post("user_id")) {
            $arr = array('err_code' => "invalid", "error_type" => "user_id_required", "message" => "Email is required");
            echo json_encode($arr);
            die;
        }
        if (!$this->input->get_post("amount")) {
            $arr = array('err_code' => "invalid", "error_type" => "amount_required", "message" => "Subscription Amount is required");
            echo json_encode($arr);
            die;
        }

        $user_id = $this->input->get_post("user_id");

        $amount = $this->input->get_post('amount');
        $tax = $this->input->get_post('tax');

        $data = array(
            "ref_id" => $this->generate_transaction_token(),
            "user_id" => $user_id,
            "amount" => $amount,
            "tax1" => 0,
            "total_amount" => $amount + $tax,
            "type" => "Payment Gateway",
            "payment_date" => date("Y-m-d"),
            "remark" => "Renewal requested",
            "created_at" => time()
        );

        $response = $this->db->insert("payments", $data);
        if ($response) {
            $arr = array('err_code' => "valid",
                "title" => "Add Money Request",
                "transaction_id" => $data['ref_id'],
                "user_details" => $this->user_model->get_user_details($user_id)
            );
        }
        echo json_encode($arr);
    }

    function generate_transaction_token() {
        $ref_id = generateRandomNumber(8);
        if ($this->db->get_where("payments", ["ref_id" => $ref_id])->num_rows() == 0) {
            return $ref_id;
        } else {
            return $this->generate_transaction_token();
        }
    }

}
