<?php

header('Content-type: application/json');

class Login extends MY_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('login_model');
    }

    function index() {
        //Inputs: employee_id, password 
        //Table: staff
		if (!$this->input->get_post('employee_id')) {
			$arr = array(
				'err_code' => "invalid", 
				"error_type" => "employee_id_required", 
				"message" => "Please enter employee"
			);
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post('password')) {
			$arr = array(
				'err_code' => "invalid", 
				"error_type" => "password_required", 
				"message" => "Please enter Password"
			);
            echo json_encode($arr);
            die;
        }
		
        $data = $this->db->get_where("staff", ["employee_id" => $this->input->get_post('employee_id')])->row();
        if ($data) {
			
			if($data->image){
				$data->image = FILE_UPLOAD_FOLDER_IMG_PATH.$data->image;
			}else{
				$data->image = "";
			}
			
            $_REQUEST['current_password'] = $this->input->get_post('password');

            if ($data->status == 0) {
                $arr = array('err_code' => "invalid", "message" => "Sorry, your account is suspended, please contact admin");
            }  else if ($this->staff_model->check_for_current_password_ok($data->id) == false) {
                $arr = array('err_code' => "invalid", "data" =>[], "message" => "Invalid Current Password");
            } else {
				unset($data->password);
				unset($data->salt);
                $arr = array('err_code' => "valid", "message" => "User Details", "data" => $data);
            }
        } else {
            $arr = array('err_code' => "invalid", "message" => "Sorry, this account does not existed");
        }
        echo json_encode($arr);
    }

    function get_profile($staff_id) {
        $data = $this->db->get_where("staff", ["id" => $staff_id])->row();
		if($data){
			if($data->image){
				$data->image = FILE_UPLOAD_FOLDER_IMG_PATH.$data->image;
			}else{
				$data->image = "";
			}
		}
        return $data;
    }

}
