<?php
header('Content-type: application/json');
class Month_report extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        if (!$this->input->get_post("staff_id")) {
            $arr = array('err_code' => "invalid", "error_type" => "staff_id_required", "message" => "Staff id is required");
            echo json_encode($arr);
            die;
        }
		
		if (!$this->input->get_post("start_date")) {
            $arr = array('err_code' => "invalid", "error_type" => "start_date_required", "message" => "Start date is required");
            echo json_encode($arr);
            die;
        }
		
		$staff_id = $this->input->get_post("staff_id");
		$given_date = $this->input->get_post('start_date');
		$given_month_index = date("m", strtotime($given_date));
		$given_year = date("Y",  strtotime($given_date));
		
		$number_of_days = cal_days_in_month(CAL_GREGORIAN, $given_month_index, $given_year); // 31
		
		//echo "There were {$number_of_days} days in August ".$given_year;
		
		//echo "Start Date ". $given_date;
		
		$end_date = $given_year."-".$given_month_index."-".$number_of_days;
		
		//echo " End date : ".$end_date; die;
		
		$data = [];
		
		for($i=1; $i<=$number_of_days; $i++){
			
			$lpd = $i<10?"0".$i:$i;
			
			$date = $given_year."-".$given_month_index."-".$lpd;
			
			$this->db->where("status", 1);
			$this->db->where("staff_id", $staff_id);
			$this->db->where("date", $date);
			$result = $this->db->get("staff_attendance");
			if($result->num_rows()){
				$is_present = 1;	
			}else{
				$is_present = 0;	
			}
			$data[] = array(
				"date" => $date,
				"is_present" => $is_present
			);
		}
		
		if($data){
			$arr = array(
				'err_code' => "valid", 
				"message" => "Staff attendance for the selected month", 
				"staff_id"=>$staff_id,
				"start_date"=>$given_date,
				"end_date"=>$end_date,
				"data"=>$data
				
			);
		}else{
			$arr = array(
				'err_code' => "invalid", 
				"message" => "Staff attendance for the selected month", 
				"staff_id"=>$staff_id,
				"start_date"=>$given_date,
				"end_date"=>$end_date,
				"data"=>[]
				
			);
		}
		
		echo json_encode($arr);
		
		die;
		$this->db->where("status", 1);
		$this->db->where("staff_id", $staff_id);
		$this->db->where("date >= ", $given_date);
		$this->db->where("date <= ", $end_date);
		$this->db->order_by("id", "asc");
		$this->db->get("staff_attendance");
		echo $this->db->last_query(); die;
		
	}
}