<?php
header('Content-type: application/json');
class Staff_attendance extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function in() {
        if (!$this->input->get_post("staff_id")) {
            $arr = array('err_code' => "invalid", "error_type" => "staff_id_required", "message" => "Staff id is required");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("image")) {
            $arr = array('err_code' => "invalid", "error_type" => "image_required", "message" => "Image is required");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("date_time")) {
            $arr = array('err_code' => "invalid", "error_type" => "date_time_required", "message" => "Date and time is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("lat")) {
            $arr = array('err_code' => "invalid", "error_type" => "lat_required", "message" => "GPS Connection is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("lng")) {
            $arr = array('err_code' => "invalid", "error_type" => "lng_required", "message" => "GPS Connection is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		
		$staff_id = $this->input->get_post("staff_id");
		$this->db->where("(date LIKE '".date('Y-m-d')."%')");
		$this->db->where("staff_id", $staff_id);
		$this->db->where("type", "In");
		$this->db->where("status", 1);
		if($this->db->get("staff_attendance")->num_rows()){
			$arr = array('err_code' => "invalid", "message" => "Your attendance already submitted for today");
            echo json_encode($arr);
            die;
		}
		
		$image_path = $this->upload_captured_image();
		
		$time_info = $this->get_time_difference_for_in($this->input->get_post("date_time"), $staff_id);
		
		$actual_in_time = date("Y-m-d")." ".$this->get_staff_in_time($staff_id);
		$actual_out_time = date("Y-m-d")." ".$this->get_staff_out_time($staff_id);
		
		$this->db->set("actual_office_in_time", $actual_in_time);
		
		$this->db->set("duration_span", $time_info->duration_span);
		$this->db->set("activity_type", $time_info->activity_type);
		$this->db->set("comment", $time_info->comment);
		
		$this->db->set("staff_id", $staff_id);
		$this->db->set("date_time",  $this->input->get_post("date_time"));
		$this->db->set("date",  $this->input->get_post("date_time"));
		$this->db->set("lat", $this->input->get_post("lat"));
		$this->db->set("lng", $this->input->get_post("lng"));
		$this->db->set("captured_image", $image_path);
		$this->db->set("type", "In");
		$this->db->set("created_at", time());
		$this->db->set("status", 1);
		$response = $this->db->insert("staff_attendance");
		if($response){
			$arr = array('err_code' => "valid", "message" => "Submitted");
		}
        
        echo json_encode($arr);
    }
	
	function out(){
		if (!$this->input->get_post("staff_id")) {
            $arr = array('err_code' => "invalid", "error_type" => "staff_id_required", "message" => "Staff id is required");
            echo json_encode($arr);
            die;
        }
		
		if (!$this->input->get_post("image")) {
            $arr = array('err_code' => "invalid", "error_type" => "image_required", "message" => "Image is required");
            echo json_encode($arr);
            die;
        }
		
		if (!$this->input->get_post("date_time")) {
            $arr = array('err_code' => "invalid", "error_type" => "date_time_required", "message" => "Date and time is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("lat")) {
            $arr = array('err_code' => "invalid", "error_type" => "lat_required", "message" => "GPS Connection is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		if (!$this->input->get_post("lng")) {
            $arr = array('err_code' => "invalid", "error_type" => "lng_required", "message" => "GPS Connection is required", 
			"format"=>"Y-m-d H:i:s");
            echo json_encode($arr);
            die;
        }
		
		$staff_id = $this->input->get_post("staff_id");
		 
		$this->db->where("(date LIKE '".date('Y-m-d')."%')");
		$this->db->where("staff_id", $staff_id);
		$this->db->where("type", "Out");
		$this->db->where("status", 1);
		if($this->db->get("staff_attendance")->num_rows()){
			$arr = array('err_code' => "invalid", "message" => "Your attendance already submitted for today");
            echo json_encode($arr);
            die;
		}
		
       
		$image_path = $this->upload_captured_image();
		
		$time_info = $this->get_time_difference_for_out($this->input->get_post("date_time"), $staff_id);
		
		$actual_in_time = date("Y-m-d")." ".$this->get_staff_in_time($staff_id);
		$actual_out_time = date("Y-m-d")." ".$this->get_staff_out_time($staff_id);
		
		$this->db->set("actual_office_out_time", $actual_out_time);
		$this->db->set("duration_span", $time_info->duration_span);
		$this->db->set("activity_type", $time_info->activity_type);
		$this->db->set("comment", $time_info->comment);
		
		$this->db->set("staff_id", $staff_id);
		$this->db->set("date_time",  $this->input->get_post("date_time"));
		$this->db->set("date",  $this->input->get_post("date_time"));
		$this->db->set("lat", $this->input->get_post("lat"));
		$this->db->set("lng", $this->input->get_post("lng"));
		$this->db->set("captured_image", $image_path);
		$this->db->set("type", "Out");
		$this->db->set("created_at", time());
		$this->db->set("status", 1);
		$response = $this->db->insert("staff_attendance");
		if($response){
			$arr = array('err_code' => "valid", "message" => "Submitted");
		}
        
        echo json_encode($arr);
	}
	
	function upload_captured_image() {
        // keyname is image
$staff_id = $this->input->get_post("staff_id");
		$log_name = md5(microtime())."staff_id_".$staff_id.time().'.jpeg';
		$logo_image = FILE_UPLOAD_FOLDER.$log_name;
		if(file_put_contents($logo_image, base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $this->input->get_post('image'))))){
			return $log_name;
		}else{
			$arr = array('err_code' => "invalid", "message" => 'Unable to upload image', "data"=>[]);
		}
		echo json_encode($arr);
	}
	
	function get_time_difference_for_in($submitted_time, $staff_id){
		
		$opening_time = date("Y-m-d")." ".$this->get_staff_in_time($staff_id);
		$minutes = round((strtotime($opening_time) - strtotime($submitted_time)) / 60);
		
		if($minutes>=0){
			$arr = (object)[
				"activity_type"=>"Before", 
				"duration_span"=>$minutes, 
				"comment"=>convert_minutes_to_string($minutes)." before"
			];
		}else{
			$arr = (object)[
				"activity_type"=>"Late", 
				"duration_span"=>abs($minutes), 
				"comment"=>convert_minutes_to_string(abs($minutes))." late"
			];
		}
		return $arr; 
	}
	
	function get_time_difference_for_out($submitted_time, $staff_id){
		$closing_time = date("Y-m-d")." ".$this->get_staff_out_time($staff_id);
		$minutes = round((strtotime($closing_time) - strtotime($submitted_time)) / 60);
		
		if($minutes>=0){
			$arr = (object)[
				"activity_type"=>"Before", 
				"duration_span"=>$minutes, 
				"comment"=>convert_minutes_to_string(abs($minutes))." before"
			];
		}else{
			$arr = (object)[
				"activity_type"=>"Late", 
				"duration_span"=>$minutes, 
				"comment"=> convert_minutes_to_string(abs($minutes))." late"
			];
		}
		return $arr; 
	}
	
	function get_business_timings(){
		$this->db->select("opening_time, closing_time");
		return $this->db->get("business_timings")->row();
	}
	
	function get_staff_in_time($staff_id){
		$this->db->where("id", $staff_id);
		$in_time = $this->db->get("staff")->row()->in_time;
		return $in_time;
	}
	
	function get_staff_out_time($staff_id){
		$this->db->where("id", $staff_id);
		$out_time = $this->db->get("staff")->row()->out_time;
		return $out_time;
	}
	
	function check_in_time_came(){
		$actual_in_time = date("Y-m-d")." "."17:00:00";
		$submitted_time = "2018-01-31 18:47:06";
		echo round((strtotime($closing_time) - strtotime($submitted_time)) / 60);
		die;
	}
}
