<?php

header('Content-type: application/json');

class Subscription_details extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        $user_id = $this->input->get_post('user_id');
        $udetails = $this->user_model->get_user_details($user_id);
        $site_details = $this->site_model->get_site_properties();

        $user_status = $this->user_model->check_is_subscription_expired($user_id);
        if ($user_status == false) {
            $arr = array('err_code' => "valid",
                "message" => " Your AS MCX Free tips " . $udetails->subscription_mode . " expired, Please renew it.",
                "expiry_date" => $this->user_model->get_user_details($user_id)->subscription_expiry_date,
                "cost" => $this->site_model->get_site_properties()->subscription_price,
                "name" => $this->user_model->get_user_details($user_id)->name,
                "subscrition_text" => "Get " . $site_details->valid_for_days . " days subscrition at Rs." . $site_details->subscription_price,
                "subscription_mode" => $udetails->subscription_mode,
                "user_id" => (int) $user_id
            );
        } else {
            $arr = array('err_code' => "valid",
                "message" => "Your AS MCX Free tips " . $udetails->subscription_mode . " will expire on ",
                "expiry_date" => $udetails->subscription_expiry_date,
                "cost" => $this->site_model->get_site_properties()->subscription_price,
                "subscrition_text" => "Get " . $site_details->valid_for_days . " days subscrition at Rs." . $site_details->subscription_price,
                "subscription_mode" => $udetails->subscription_mode,
                "name" => $udetails->name,
                "user_id" => (int) $user_id
            );
        }
        echo json_encode($arr);
    }

}
