<?php

header('Content-type: application/json');

class Transactions extends MY_Controller {

    public function __construct() {
        parent::__construct();
    }

    function index() {
        $token = $this->input->get_post("token");
        $user_id = $this->get_user_id($token);
        $filter = array();

        $total_results = $this->customer_model->get_transactions($user_id);

        $limit = $this->input->get_post("limit") ? $this->input->get_post("limit") : ORDERS_PER_PAGE;
        $_GET['page'] = $this->input->get_post("start");
        $start = $this->input->get_post("start") > 1 ? ($this->input->get_post("start") - 1) * $limit : 0;


        $pagination = my_pagination("search_result.php", $limit, $total_results, true);
        $pagination['pagination'] = str_replace("&amp;", "&", $pagination['pagination']);

        $data = $this->customer_model->get_transactions($user_id, $start, $limit);

        if ($data) {
            $arr = array('err_code' => "valid", "title" => "Transactions", "message" => "Total Orders $total_results", "total_results" => $total_results, "pagination" => $pagination, "data" => $data);
        } else {
            $arr = array('err_code' => "invalid", "data" => [], "message" => "You have not yet placed any order");
        }

        echo json_encode($arr);
    }

}
