<?php

class Staff_model extends CI_Model {

    function is_employee_exists($employee_id) {
        $data = $this->db->get_where("staff", ['employee_id' => $employee_id]);
        if ($data->num_rows() == 0) {
            return false;
        }
        $data = $data->row();
        return $data->id;
    }

    function check_user_status($staff_id) {
        $data = $this->db->get_where("staff", ['id' => $staff_id])->row();
        if ($data) {
            if ($data->status == 0) {
                return false;
            } else {
                return true;
            }
        }
        return true;
    }

    function staff_profile_password_update($staff_id) {
        extract($_REQUEST);
        $salt = rand(552555, 258242152);
        $smsPwd = $password;
        $password = md5($password . $salt);
        $this->db->set("password", $password);
        $this->db->set("salt", $salt);
        $this->db->where("id", $staff_id);
        if ($this->db->update("staff")) {

            $ud = $this->get_staff_details($staff_id);

            return true;
        } else {
            return false;
        }
    }

    function check_for_current_password_ok($staff_id) {
        extract($_REQUEST);
        $ud = $this->get_staff_details($staff_id);
        if ($ud->password == md5($current_password . $ud->salt)) {
            return true;
        } else {
            return false;
        }
    }

	function get_staff_details($staff_id) {
        $user_details = $this->db->get_where("staff", ['id' => $staff_id])->row();
        return $user_details;
    }

    function login_validation($staff_id, $password) {
        $data = $this->get_staff_details($staff_id);
        if ($data->password == md5($password . $data->salt)) {
            return true;
        } else {
            return false;
        }
    }
	
	function get_staff_attendence_report_for_date($staff_item, $date, $filter=[]){
		

		if(isset($filter['late_comers'])){
			$this->db->where("activity_type", "Late");
			$this->db->where("duration_span > ", GRACE_MINUTES);
		}
		$this->db->where("date", $date);
		$this->db->where("status", 1);
		$this->db->where("staff_id", $staff_item->id);
		$this->db->where("type", "In");
		$staff_item->check_in = $this->db->get("staff_attendance")->row(); 
		if($staff_item->check_in){
			if($staff_item->check_in->date_time){
				$staff_item->check_in->time = date("h:i A", strtotime($staff_item->check_in->date_time));
				if($staff_item->check_in->activity_type == "Late"){
					$staff_item->check_in->bootstrap_class = "text-danger";
				}else if($staff_item->check_in->activity_type == "Before"){
					$staff_item->check_in->bootstrap_class = "text-success";
				}
			}else{
				$staff_item->check_in->time = "<span class='text-danger'>--</span>";
				$staff_item->check_in->comment = "<span class='text-danger'>--</span>";
			}
		}
		
		
		$this->db->where("date", $date);
		$this->db->where("status", 1);
		$this->db->where("staff_id", $staff_item->id);
		$this->db->where("type", "Out");
		$staff_item->check_out = $this->db->get("staff_attendance")->row();
		
		if($staff_item->check_out){
			if($staff_item->check_out->date_time){
				$staff_item->check_out->time = date("h:i A", strtotime($staff_item->check_out->date_time));
				
				if($staff_item->check_out->activity_type == "Late"){
					$staff_item->check_out->bootstrap_class = "text-success";
				}else if($staff_item->check_out->activity_type == "Before"){
					$staff_item->check_out->bootstrap_class = "text-danger";
				}
			}else{
				$staff_item->check_out->time = "<span class='text-danger'>--</span>";
				$staff_item->check_out->comment = "<span class='text-danger'>--</span>";
			}
			
		}
		
		
		$staff_item->num_of_days_late = $this->get_number_of_days_late($staff_item->id);
		return $staff_item;
	}
	
	function get_number_of_days_late($staff_id, $from_date=null, $to_date=null){

		if($from_date==null){
			$from_date = date("Y-m-01");
		}
		if($to_date==null){
			$to_date = date("Y-m-d");
		}
		$this->db->where("staff_id", $staff_id);
		$this->db->where("type", "In");
		$this->db->where("status", 1);
		$this->db->where("activity_type", "Late");
		$this->db->where("duration_span > ", GRACE_MINUTES);
		$this->db->where("date <= ", $to_date);
		$cnt = $this->db->count_all_results("staff_attendance");
		return $cnt;
	}
	
	function get_total_number_of_days_attend($staff_id, $from_date, $to_date){
		$this->db->where("staff_id", $staff_id);
		$this->db->where("type", "In");
		$this->db->where("status", 1);
		$this->db->where("date >= ", $from_date);
		$this->db->where("date <= ", $to_date);
		$cnt = $this->db->count_all_results("staff_attendance");
		return $cnt;
	}
}
