<div class="wrapper wrapper-content animated fadeInRight">
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox float-e-margins">
                <div class="ibox-title">
                    <h4 class="myhead">eCommerce Order
                        <b class="pull-right">#<?=$item->booking_id?></b>
                    </h4>
                </div>
				<div class="ibox-content">
					<div class="row r-m-05 row-height">
						<div class="col-md-12 c-p-05 col-height">
							<div class="whitebox whitebox-height">
								<div class="row r-m-05">
									<div class="col-md-12 c-p-05">
										<div class="panel panel-default m-b-1">
											<div class="panel-heading">
												<h3 class="panel-title">Delivery Details</h3>
											</div>
											<div class="panel-body">
												<b><?=$item->customer_name?></b>
												<pre><?=$item->customer_address.'<br>Pincode: '.$item->customer_pincode?></pre>
											</div>
										</div>
									</div>
								</div>
								<table class="table order_table m-a-0 m-b-1">
									<thead>
										<tr>
											<th>Order Date</th>
											<th>Order Id</th>
											<th>Order Status</th>
											<?php
												if(isset($item->vendor_name)){
											?>
											<th>Executive Name</th>
											<?php
												}if(isset($item->vendor_mobile)){
											?>
											 <th>Executive Mobile</th>
											<?php
												}
											?>
										</tr>
									</thead>
									<tbody>
										<tr>
											<td><?=date('d-m-Y h:i a',$item->created_at)?></td>
											<td><b><?=$item->booking_id?></b></td>
											<?php
												if($item->service_status == 'Pending'){
													$bootstrap_class = 'warning';
												}elseif($item->service_status == 'Accepted'){
													$bootstrap_class = 'success';
												}elseif($item->service_status == 'Cancelled'){
													$bootstrap_class = 'danger';
												}elseif($item->service_status == 'Completed'){
													$bootstrap_class = 'primary';
												}elseif($item->service_status == 'Rejected'){
													$bootstrap_class = 'danger';
												}elseif($item->service_status == 'Process'){
													$bootstrap_class = 'success';
												}
											?>
											<td><span class="label label-<?=$bootstrap_class?>"><?=$item->service_status?></span></td>
											<?php
												if(isset($item->vendor_name)){
											?>
											<td><b><?=$item->vendor_name?></b></td>
											<?php
												}if(isset($item->vendor_mobile)){
											?>
											<td><b><?=$item->vendor_mobile?></b></td>
											<?php
												}
											?>
										</tr>
									</tbody>
								</table>
								<table class="table order_table m-a-0 m-b-1">
									<thead>
										<tr>
											<th><strong>#</strong></th>
											<th><strong>Item Name</strong></th>
											<th width="120"><strong>Qty</strong></th>
										</tr>
									</thead>
									<tbody>
										<?php
											$i=1;
											foreach($product_data as $pditem){
										?>
										<tr>
											<td><?=$i?></td>
											<td><?=$pditem->product_name?></td>
											<td><?=$pditem->qty?></td>
										</tr>
										<?php
												$i++;
											}
										?>
									</tbody>
								</table>
								<div class="panel panel-default m-b-1" ng-show="order_view.service_status === 'Completed' && order_view.payment_status === 'Paid' && order_view.is_customer_accepted == 1">
									<div class="panel-heading text-center">
										<h3 class="panel-title">Summary</h3>
									</div>
									<div class="panel-body text-center">
										<pre style="text-align: left;"><?= ($item->remark != '') ? $item->remark:'-'?></pre>
										<p> Total Amount : <b><?=number_format($item->payable_amount,2)?></b> </p>
										<p> Admin Share : <b><?=number_format($item->admin_share_amount,2)?></b> </p>
										<p> Franchise Share : <b><?=number_format($item->franchise_share_amount,2)?></b> </p>
										<p> Referral Share : <b><?=number_format($item->referral_share_amount,2)?></b> </p>
									</div>
								</div>
								<div class="row r-m-05" ng-if="order_view.log_history">
									<div class="col-md-12 c-p-05">
										<div class="panel panel-default m-b-1">
											<div class="panel-heading">
												<h3 class="panel-title">Process Log</h3>
											</div>
											<div class="panel-body">
												<table class="table table-bordered">
													<thead>
														<tr>
															<th>Type</th>
															<th>Date Time</th>
															<th>Person Name</th>
															<th>Role</th>
														</tr>
													</thead>
													<tbody>
														<?php
															foreach($process_log as $plitem){
														?>
														<tr>
															<td><?=$plitem->action_type?></td>
															<td><?=date('d-m-Y h:i a',$plitem->action_triggered_at)?></td>
															<td><?=$plitem->person_name?></td>
															<td><?=$plitem->role_name?></td>
														</tr>
														<?php
															}
														?>
													</tbody>
												</table>
											</div>
										</div>
									</div>
								</div> 
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>