<div class="wrapper wrapper-content animated fadeInRight">

    <form class="form">
        <div class="form-group col-md-4">
            <input type="number" class="form-control" name="q" value="<?= $this->input->get_post('q') ?>" placeholder="Enter Mobile Number">
        </div>
        <button type="submit" class="btn btn-info">Search</button>
    </form>
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Payment Ledger</h5>
                        <div class="ibox-tools">
                            <a class="btn btn-primary btn-xs" style="cursor: pointer" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus" aria-hidden="true"></i> Add or WithDraw Amount
                            </a>
                        </div>
                    </div>
                    <div class="ibox-content">
                        <table class="table table-bordered">
                            <tr>
                                <th>Name: <?php echo $user->name ?></th>
                                <th>Mobile: <?php echo $user->mobile ?></th>
                                <th>Role: <?php echo $this->roles_model->get_role_name_by_id($user->role_id) ?></th>

                                <?php if ($user->role_id == $this->roles_model->get_customer_role_id()) { ?>
                                    <th>Credit Limit: <?php echo $user->credit_limit ?></th>    
                                <?php } ?>

                                <?php
                                if ($user->role_id == $this->roles_model->get_customer_role_id()) {
                                    $wallet_balance = $this->customer_model->get_wallet_balance($user->id);
                                } elseif ($user->role_id == $this->roles_model->get_vendor_role_id()) {
                                    $wallet_balance = $this->vendor_model->get_wallet_balance($user->id);
                                } elseif ($user->role_id == $this->roles_model->get_franchise_role_id()) {
                                    $wallet_balance = $this->franchise_model->get_wallet_balance($user->id);
                                }
                                ?>
                                <th>Wallet Balance: <?php echo $wallet_balance; ?></th>
                            </tr>
                        </table>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>S.No</th>
                                    <th>Request ID</th>
                                    <th>Ref No</th>
                                    <th>Date</th>
                                    <th>Type</th>
                                    <th>Amount</th>
                                    <th>By</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $i = 1;
                                foreach ($payments_ledger as $item) {
                                    ?>
                                    <tr>
                                        <td><?= $i++ ?></td>
                                        <td><?= $item->request_id ?></td>
                                        <td><?= $item->transaction_ref_id ?></td>
                                        <td><?= date("d-m-Y", $item->created_at) ?></td>
                                        <td><?= $item->action_type ?></td>
                                        <td><?= $item->amount ?></td>
                                        <td><?= $item->by_ref ?></td>
                                        <td><?= $item->request_status ?></td>
                                        <td>
                                            <?php if ($item->request_status == "Pending") { ?>
                                                <a href="<?= base_url() ?>admin/payments_ledger/approve?q=<?= $this->input->get_post('q') ?>&id=<?= $item->id ?>">Approve</a>
                                            <?php } else { ?>
                                                <?= $item->request_status ?>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div id="myModal" class="modal fade" role="dialog">
        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                    <h4 class="modal-title">Update Wallet Add (or) WithDraw Amount</h4>
                </div>
                <div class="modal-body">
                    <form method="post">
                        <input type="hidden" name="user_id" value="<?= $user->id ?>"/>
                        <div class="form-group">
                            <label for="amount">Amount:</label>
                            <input type="number" min="1" max="99999" class="form-control" name="amount" required>
                        </div>
                        <div class="form-group">
                            <label for="action_type">Transaction Type:</label>
                            <select name="action_type" class="form-control" required>
                                <option value="">---Select---</option>
                                <option value="Credit">Credit Amount to Wallet</option>
                                <option value="Debit">Debit Amount from Wallet</option>
                            </select>
                        </div>
                        <?php /*
                          <div class="form-group">
                          <label for="action_by">For:</label>
                          <select name="action_by" class="form-control" required>
                          <option value="">---Select---</option>
                          <option value="Commission">Commission</option>
                          <option value="">Add Money</option>
                          <option value="">Withdraw Money</option>
                          </select>
                          </div>
                         * 
                         */ ?>

                        <div class="form-group">
                            <label for="transaction_ref_id">Transaction Ref ID:</label>
                            <input type="text" class="form-control" name="transaction_ref_id" required>
                        </div>
                        <div class="form-group">
                            <label for="transaction_ref_id">Remarks:</label>
                            <textarea class="form-control" name="remark"></textarea>
                        </div>
                        <button type="submit" class="btn btn-success">Update Wallet</button>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                </div>
            </div>

        </div>
    </div>
</div>
