<div class="wrapper wrapper-content animated fadeInRight">

    <form class="form">
        <div class="row">
            <div class="form-group col-md-2">
                <select class="form-control" name="s" id="s" required>
                    <option value="">Select State</option>
                    <?php
                    foreach ($states as $sitem) {
                        $selected = '';
                        if (isset($state_id) && ($sitem->id == $state_id)) {
                            $selected = 'selected="selected"';
                        }
                        echo '<option value="' . $sitem->id . '" ' . $selected . '>' . $sitem->name . '</option>';
                    }
                    ?>
                </select>
            </div>
            <div class="form-group col-md-2">
                <select class="form-control" name="c" required>
                    <option value="">Select City</option>
                    <?php
                    if (isset($cities) && (count($cities) > 0))
                        foreach ($cities as $citem) {
                            $selected = '';
                            if ($this->input->get_post('c') && ($citem->id == $this->input->get_post('c'))) {
                                $selected = 'selected="selected"';
                            }
                            echo '<option value="' . $citem->id . '" ' . $selected . '>' . $citem->name . '</option>';
                        }
                    ?>
                </select>
            </div>
            <div class="form-group col-md-2">
                <select class="form-control" name="r" required>
                    <option value="">Select Type</option>
                    <?php
                    foreach ($roles as $ritem) {
                        $selected = '';
                        if ($this->input->get_post('r') && ($ritem->id == $this->input->get_post('r'))) {
                            $selected = 'selected="selected"';
                        }
                        echo '<option value="' . $ritem->id . '" ' . $selected . '>' . $ritem->name . '</option>';
                    }
                    ?>
                </select>
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control datepicker" name="fd" value="<?= $this->input->get_post('fd') ?>" placeholder="From Date">
            </div>
            <div class="form-group col-md-2">
                <input type="text" class="form-control datepicker" name="td" value="<?= $this->input->get_post('td') ?>" placeholder="To Date">
            </div>
            <div class="form-group col-md-2">
                <button type="submit" class="btn btn-info">Search</button>
            </div>
        </div>
    </form>
    <div class="wrapper wrapper-content animated fadeInRight">
        <div class="row">
            <div class="col-lg-12">
                <div class="ibox float-e-margins">
                    <div class="ibox-title">
                        <h5>Reports</h5>
                    </div>
                    <div class="ibox-content">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover  dataTables-example" >
                                <thead>
                                    <tr>
                                        <th>S.No</th>
                                        <th>Name</th>
                                        <th>State</th>
                                        <th>City</th>
                                        <?php if ($this->input->get_post('r') == $this->roles_model->get_customer_role_id()) { ?>
                                            <th>Pincode</th>
                                        <?php } else if ($this->input->get_post('r') == $this->roles_model->get_vendor_role_id()) { ?>
                                            <th>Authorized Pincodes</th>
                                            <th>Authorized Franchise </th>
                                        <?php } else if ($this->input->get_post('r') == $this->roles_model->get_franchise_role_id()) { ?>
                                            <th>Authorized Pincodes</th>
                                        <?php } ?>
                                        <th>Mobile</th>
                                        <th>Wallet Balance</th>
                                        <?php if ($this->input->get_post('r') == $this->roles_model->get_customer_role_id()) { ?>
                                            <th>Credit Limit</th>
                                        <?php } ?>

                                        <?php if ($this->input->get_post('r') == $this->roles_model->get_franchise_role_id()) { ?>
                                            <th>Fixed Deposit</th>
                                            <th>Customers Limit</th>
                                            <th>Customers</th>
                                        <?php } ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $i = 1;
                                    foreach ($reports as $item) {
                                        ?>
                                        <tr>
                                            <td><?= $i++ ?></td>
                                            <td><?= $item->name ?></td>
                                            <td><?= $item->state_title ?></td>
                                            <td><?= $item->city_title ?></td>
                                            <td><?= $item->pincode ?></td>

                                            <?php if ($this->input->get_post('r') == $this->roles_model->get_vendor_role_id()) { ?>
                                                <td>

                                                    <?php
                                                    $f = $this->db->get_where("users", ['id' => $item->authorized_franchise_id])->row();
                                                    echo $f->name . " - " . $f->mobile;
                                                    ?>

                                                </td>
                                            <?php } ?>

                                            <td><?= $item->mobile ?></td>
                                            <td><?= $item->wallet_balance ?></td>
                                            <?php if ($this->input->get_post('r') == $this->roles_model->get_customer_role_id()) { ?>
                                                <td><?= $item->credit_limit ?></td>
                                            <?php } ?>
                                            <?php if ($this->input->get_post('r') == $this->roles_model->get_franchise_role_id()) { ?>
                                                <td><?= $item->fixed_deposit ?></td>
                                                <td><?= $item->max_customer_allowed ?></td>
                                                <td><?= $this->franchise_model->get_available_customers(array(), $item->id); ?></td>
                                            <?php } ?>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- Page-Level Scripts -->
<script>
    $(document).ready(function () {
        $('.dataTables-example').DataTable({
            pageLength: 25,
            responsive: true,
            dom: '<"html5buttons"B>lTfgitp',
            buttons: [
                {extend: 'copy'},
                {extend: 'excel', title: ' Pre Registrations'},
                {extend: 'pdf', title: ' Pre Registrations'},

                {extend: 'print',
                    customize: function (win) {
                        $(win.document.body).addClass('white-bg');
                        $(win.document.body).css('font-size', '10px');

                        $(win.document.body).find('table')
                                .addClass('compact')
                                .css('font-size', 'inherit');
                    }
                }
            ]

        });
    });
</script>
<script>
    $(document).ready(function () {
        $(document).on('change', '#s', function () {
            window.location = "<?= base_url() ?>admin/reports/manage/" + $(this).val();
        });
    });
</script>